<?php
require __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../includes/db.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$stmt = $pdo->query('SELECT c.*, p.name as package_name FROM customers c LEFT JOIN packages p ON c.package_id=p.id');
$rows = $stmt->fetchAll();

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->fromArray(['ID','Nama','Alamat','Phone','Email','NIK','Paket','Status','Created'], null, 'A1');
$rowNum = 2;
foreach ($rows as $r) {
  $sheet->fromArray([$r['id'],$r['full_name'],$r['address'],$r['phone'],$r['email'],$r['nik'],$r['package_name'],$r['status'],$r['created_at']], null, 'A' . $rowNum);
  $rowNum++;
}
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="pelanggan.xlsx"');
header('Cache-Control: max-age=0');
$writer->save('php://output');
exit;
